/*
 * PitchAngleExpositionAction.h
 *
 *  Created on: 04-april-2010
 *      Author: Vitaly Malakhov
 */

/*! @file PitchAngleExpositionAction.h The PitchAngleExpositionAction class declaration file. */

#include "../Histo2DAction/Histo2DAction.h"

#ifndef PITCHANGLEEXPOSITIONACTION_H_
#define PITCHANGLEEXPOSITIONACTION_H_

/*! @brief An action that fills Zenith vs Azimuth angle of vector of magnetic field B with live-time weight
 *         and optionally can fill Zenith vs Azimuth histogramm with live time weight for every possible
 *         direction of incoming particle for fixed pitch angle
 */

class PitchAngleExpositionAction: public Histo2DAction<Float_t> {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   * @param calcoPitchExpo if true it will calculate and fill Zenith vs Azimuth histogramm with live time weight for 
	      every possible direction of incoming particle for fixed pitch angle. It is recommed to cet it true just
             for processing of big data sets (several month for example) since this calculation is long process
   * @param nPitchBins number of pitch-angles for calculation exposition.
   * @param lowerPitch lower limit of pitch-angle range.
   * @param upperPitch upper limit of pitch-angle range.
   */
  PitchAngleExpositionAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot = true, bool outText = true, TString title = "Exposition Zenith Vs. Azimuth of B", bool CalcPitchExpo = false, UInt_t nPitchBins = 36, Float_t lowerPitch = 0., Float_t upperPitch = 180.);

  /*! @brief Destructor. */
  ~PitchAngleExpositionAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Write histograms into file. */
  void Finalize();

private:

vector<TH2F> _pitchAngleHisto;
bool _calcPitchExpo;
UInt_t _nPitchBins;
Float_t _lowerPitch;
Float_t _upperPitch;

};
#endif /* PITCHANGLEEXPOSITIONACTION_H_ */
