/*
 * TrkRigHistoAction.cpp
 *
 *  Created on: 2009-06-05
 *      Author: S. Ricciarini
 *      (Re-edited: 2009-08-25 N. Mori)
 */

/*! @file TrkRigHistoAction.cpp The TrkRigHistoAction class implementation file. */

#include "TrkRigHistoAction.h"

TrkRigHistoAction::TrkRigHistoAction(const char *actionName, TString outFileBase,
    TString mode, bool outRoot, bool outText, TString title) :
  Histo1DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText) {
}

void TrkRigHistoAction::OnGood(PamLevel2 *event) {

  double rig = 1. / event->GetTrack(0)->GetTrkTrack()->GetDeflection(); // rigidity with sign
  Fill(rig);

}
