/*
 * TrkMDRHistoAction.h
 *
 *  Created on: 03-aug-2009
 *      Author: S. Ricciarini
 */


/*! @file TrkMDRHistoAction.h The TrkMDRHistoAction class declaration file. */

#ifndef TRKMDRHISTOACTION_H_
#define TRKMDRHISTOACTION_H_

#include "../Histo1DAction/Histo1DAction.h"

/*! @brief An action that fills an MDR (GV) 1D histogram.
 */
class TrkMDRHistoAction: public Histo1DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, the output file in ROOT format will be produced.
   * @param outText If true, the output file in text format will be produced.
   * @param title The ROOT histogram title.
   */
  TrkMDRHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot = true,
      bool outText = true, TString title = "MDR");

  /*! @brief Destructor */
  ~TrkMDRHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

};

#endif /* TRKMDRHISTOACTION_H_ */
