/*
 * LiveTimeRunEventHistoAction.cpp
 *
 *  Created on: 18/jan/2010
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file LiveTimeRunEventHistoAction.cpp The LiveTimeRunEventHistoAction class implementation file. */

#include "LiveTimeRunEventHistoAction.h"

LiveTimeRunEventHistoAction::LiveTimeRunEventHistoAction(const char *actionName, TString outFileBase, UInt_t eventID,
    TString mode) :
  Histo1DAction<Float_t> (actionName, "Live Time", outFileBase, mode, true), _eventID(eventID) {

  SetXAxis("LT (s)", 100, 0., 4.5); // Default axis
}

void LiveTimeRunEventHistoAction::OnGood(PamLevel2 *event) {

  if (event->GetRunInfo()) {

    UInt_t eventPN = event->GetRunInfo()->RUNHEADER_PKT + 2 + _eventID; // RUNHEADER_PKT is UInt_t

    //    cout << "expected " << eventPN << "\t";

    //    cout << "actual " << event->GetOrbitalInfo()->pkt_num << endl;

    if (event->GetOrbitalInfo()->pkt_num == eventPN) {
      Float_t _LT = 0.16 * (float) (event->GetTrigLevel2()->dltime[0]) / 1000.; // in seconds
      Fill(_LT);

      //      cout << "ok : " << _LT << endl;

    }

  }

}


