/*
 * CaloQtotHistoAction.cpp
 *
 *  Created on: 2010-03-12
 *      Author: S. Ricciarini
 */

/*! @file CaloQtotHistoAction.cpp The CaloQtotHistoAction class implementation file. */

#include "CaloQtotHistoAction.h"

CaloQtotHistoAction::CaloQtotHistoAction(const char *actionName, TString outFileBase,
    TString mode, bool outRoot, bool outText, TString title) :
  Histo1DAction<Double_t> (actionName, title, outFileBase, mode, outRoot, outText) {
}

void CaloQtotHistoAction::OnGood(PamLevel2 *event) {

  Double_t qTot = event->GetCaloLevel2()->qtot; 
  Fill(qTot);

}
