/*
 * LiveTimeRunEventHistoAction.h
 *
 *  Created on: 18/jan/2010
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file LiveTimeRunEventHistoAction.h The LiveTimeRunEventHistoAction class declaration file. */

#ifndef LIVETIMERUNEVENTHISTOACTION_H_
#define LIVETIMERUNEVENTHISTOACTION_H_

#include "../Histo1DAction/Histo1DAction.h"

/*! @brief  Fills the Live Time histogram for events with specified position in the run. */
class LiveTimeRunEventHistoAction: public Histo1DAction<Float_t> {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The output file base name.
   * @param eventID The event ID in the run (first event: 0).
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   */
  LiveTimeRunEventHistoAction(const char *actionName, TString outFileBase, UInt_t eventID = 0, TString mode = "UPDATE");

  /*! @brief Destructor. */
  ~LiveTimeRunEventHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);


private:

  TString _outFileName;
  UInt_t _eventID;
  TString _mode;
  TH1F _Histo;

};
#endif /* LIVETIMERUNEVENTHISTOACTION_H_ */
