/*
 * TrkXAngHistoAction.h
 *
 *  Created on: 2009-12-24
 *      Author: S. Ricciarini
 */

/*! @file TrkXAngHistoAction.h The TrkXAngHistoAction class declaration file. */

#ifndef TRKXANGHISTOACTION_H_
#define TRKXANGHISTOACTION_H_

#include "../Histo1DAction/Histo1DAction.h"

/*! @brief An action that fills the histogram: TRK track XZ angle (degrees) on the first TRK plane.
 */
class TrkXAngHistoAction: public Histo1DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   * @param outRoot If true, the output file in ROOT format will be produced.
   * @param outText If true, the output file in text format will be produced.
   *             in ROOT's reference guide).
   * @param title The ROOT histogram title.
   */
  TrkXAngHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot = true, bool outText = true, TString title = "XZ angle on first TRK plane");
   
  /*! @brief Destructor */
  ~TrkXAngHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:
  
};

#endif /* TRKXANGHISTOACTION_H_ */
