/*
 * TofRigPHistoAction.cpp
 *
 *  Created on: 2009-11-23
 *      Author: S. Ricciarini
 */

/*! @file TofRigPHistoAction.cpp The TofRigPHistoAction class implementation file. */

#include "TofRigPHistoAction.h"

void TofRigPHistoAction::OnGood(PamLevel2 *event) {

  Int_t iTrackTof=0; // index initialized (default) to 0 (TOF stand-alone track)
  
  if (! (_trackTof==0) ) {
    iTrackTof=*_trackTof;
  }

  Double_t _beta = event->GetToFLevel2()->CalcBeta(iTrackTof,_resMax,_qualCut,_chi2Cut);

  Double_t _mass_p=0.93827203; // GeV (pdg.web.cern.ch)

  if (-1.<_beta && _beta<1.) {

    Double_t rigMod = _mass_p*_beta/sqrt(1-pow(_beta,2)); // |rho| = (m/|Z|)*(beta/(sqrt(1-beta^2))) 

//    cout << "beta " << _beta << " rigMod " << rigMod << endl;

    Fill(rigMod);
    
    
  }

}
