/*
 * TrkSigmaDeflHistoAction.h
 *
 *  Created on: 2009-06-17
 *      Author: S. Ricciarini
 */
/*! @file TrkSigmaDeflHistoAction.h The TrkSigmaDeflHistoAction class declaration file. */

#ifndef TrkSigmaDeflHISTOACTION_H_
#define TrkSigmaDeflHISTOACTION_H_

#include "../Histo1DAction/Histo1DAction.h"

/*! @brief An action that, given the rigidity bins, fills an integral histogram with the number of events for which
 * the deflection error (sigma_defl) times a constant is smaller than minimum bin deflection=1/(maximum bin rigidity).
 *
 * For each event, the content of ALL the rigidity bins, which satisfy the above condition, is increased by 1.
 * Since this is quite different from what is done by Histo1DAction::Fill(), the OnGodd() implementation
 * is customary and doesn't call Fill(). Notice that this implies that no overflow nor underflow counter is
 * maintained (in current implementation).
 */
class TrkSigmaDeflHistoAction: public Histo1DAction<Float_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor).
   * @param sigmaDeflFactor The factor to multiply sigma_deflection by before comparing it to the deflection.
   * @param outRoot If true, the output file in ROOT format will be produced.
   * @param outText If true, the output file in text format will be produced.
   *             in ROOT's reference guide).
   * @param title The ROOT histogram title.
   */
  TrkSigmaDeflHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE",
      float sigmaDeflFactor = 1., bool outRoot = true, bool outText = true, TString title = "Sigma(deflection)");

  /*! @brief Destructor */
  ~TrkSigmaDeflHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:
  float _sigmaDeflFactor;
};

#endif /* TrkSigmaDeflHISTOACTION_H_ */
