/*
 * EvRateS11VsBabsHistoAction.h
 *
 *  Created on: 10-jun-2009
 *      Author: Nicola Mori
 */
/*! @file EvRateS11VsBabsHistoAction.h The EvRateS11VsBabsHistoAction class declaration file. */

#ifndef EVRATES11VSBABSHISTOACTION_H_
#define EVRATES11VSBABSHISTOACTION_H_

#include "../CollectionAction/CollectionAction.h"
#include <TH2F.h>

/*! @brief An action that fills an event rate on S11 Vs. modulus of the geomagnetic field 2D histogram.
 *
 * The event rate on S11 is the mean of the event rates on each PMT of S11.
 */
class EvRateS11VsBabsHistoAction: public CollectionAction {

public:
  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name.
   * @param mode The mode of file creation (see documentation of TFile constructor
   *             in ROOT's reference guide)
   */
  EvRateS11VsBabsHistoAction(const char *actionName, TString outFileName, TString mode = "UPDATE");

  /*! @brief Destructor */
  ~EvRateS11VsBabsHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the histogram to the output file. */
  void Finalize();

private:

  TString _outFileName;
  TH2F _histo;
  TString _mode;

};

#endif /* EVRATES11VSBABSHISTOACTION_H_ */
