/*
 * EvRateCorrHistoAction.cpp
 *
 *  Created on: 15-giu-2009
 *      Author: mori
 */

/*! @file EvRateCorrHistoAction.cpp The EvRateCorrHistoAction class implementation file. */

#include "EvRateCorrHistoAction.h"

EvRateCorrHistoAction::EvRateCorrHistoAction(const char *actionName, TString outFileName, TString mode) :
  CollectionAction(actionName), _outFileName(outFileName), _histo(), _mode(mode) {

  _histo.SetName(GetName());
  _histo.SetTitle("Event rate on S11 Vs. Event rate on S12");
  _histo.GetXaxis()->SetTitle("Event rate on S12 (Hz)");
  _histo.GetYaxis()->SetTitle("Event rate on S11 (Hz)");
  _histo.SetBins(100, 0., 4000., 100, 0., 4000.);
}

void EvRateCorrHistoAction::OnGood(PamLevel2 *event) {

  int totRateS11 = 0;
  for (int i = 0; i < 16; i++)
    totRateS11 += event->GetTrigLevel2()->pmtcount1[i];
  int totRateS12 = 0;
  for (int i = 16; i < 24; i++) // First 8 PMTs of S12
    totRateS12 += event->GetTrigLevel2()->pmtcount1[i];
  for (int i = 0; i < 4; i++) // Last 4 PMTs of S12
    totRateS12 += event->GetTrigLevel2()->pmtcount2[i];
  _histo.Fill((float) totRateS12 / 12., (float) totRateS11 / 16.);
}

void EvRateCorrHistoAction::Finalize() {

  TFile outFile(_outFileName, _mode);
  outFile.cd();
  _histo.Write();
  outFile.Close();
}
