/*
 * CaloChi2HistoAction.cpp
 *
 *  Created on: 04/ago/2009
 *      Author: Nicola Mori
 */

/*! @file CaloChi2HistoAction.cpp The CaloChi2HistoAction class implementation file. */

#ifndef NO_CALOAXIS

#include "CaloChi2HistoAction.h"

CaloChi2HistoAction::CaloChi2HistoAction(const char *actionName, TString outFileName, CaloAxis *xAxis, CaloAxis *yAxis,
    float min, float max, unsigned int nBins, bool logBinning, TString mode) :
    CollectionAction(actionName), _outFileName(outFileName), _xAxis(xAxis), _yAxis(yAxis), _mode(mode), _xHisto(), _yHisto(), _xyHisto() {

  Double_t *bins = new Double_t[nBins + 1];

  if (!logBinning || (logBinning && min <= 0.)) {

#ifdef DEBUGPAMCUT
    if (logbinning && rigMin <= 0.)
    cout << "Warning: logarithmic binning was chosen for X axis but min <= 0. Using linear binning."
#endif

    float step = (max - min) / nBins;
    for (unsigned int i = 0; i < nBins + 1; i++) {
      bins[i] = min + i * step;
    }

  }
  else {

    double maxExp = log10(max / min);
    for (unsigned int i = 0; i < nBins + 1; i++) {
      bins[i] = min * pow(10., (double) i / ((double) nBins) * maxExp);
    }

  }

  _xHisto.SetName(TString(GetName()) + TString("_x"));
  _xHisto.SetTitle("CALO Chi2 (X view)");
  _xHisto.SetBins(nBins, bins);
  _xHisto.GetXaxis()->SetTitle("Chi2 (X)");
  _xHisto.GetYaxis()->SetTitle("Events");

  _yHisto.SetName(TString(GetName()) + TString("_y"));
  _yHisto.SetBins(nBins, bins);
  _yHisto.SetTitle("CALO Chi2 (Y view)");
  _xHisto.GetXaxis()->SetTitle("Chi2 (Y)");
  _xHisto.GetYaxis()->SetTitle("Events");

  _xyHisto.SetName(TString(GetName()) + TString("_xy"));
  _xyHisto.SetBins(nBins, bins, nBins, bins);
  _xyHisto.SetTitle("CALO Chi2");
  _xyHisto.GetXaxis()->SetTitle("Chi2 (X)");
  _xyHisto.GetYaxis()->SetTitle("Chi2 (Y)");

}

void CaloChi2HistoAction::OnGood(PamLevel2 *event) {

  _xHisto.Fill(_xAxis->GetChi2());
  _yHisto.Fill(_yAxis->GetChi2());
  _xyHisto.Fill(_xAxis->GetChi2(), _yAxis->GetChi2());

}

void CaloChi2HistoAction::Finalize() {

  TFile outFile(_outFileName, _mode);
  outFile.cd();
  _xHisto.Write();
  _yHisto.Write();
  _xyHisto.Write();
  outFile.Close();
}

#endif /* NO_CALOAXIS */
