/*
 * SVCVsLHistoAction.cpp
 *
 *  Created on: 14/jan/2010
 *      Author: S. Ricciarini
 */

/*! @file SVCVsLHistoAction.cpp The SVCVsLHistoAction class implementation file. */

#include "SVCVsLHistoAction.h"

SVCVsLHistoAction::SVCVsLHistoAction(const char *actionName, TString outFileBase, TString mode,
    bool outRoot, bool outText, TString title) :
  Histo2DAction<Float_t> (actionName, title, outFileBase, mode, outRoot, outText) {

  SetXAxis("L ",5000,0,100);
  SetYAxis("SVC ",5000,0,100);
  
}

void SVCVsLHistoAction::OnGood(PamLevel2 *event) {

  Fill(event->GetOrbitalInfo()->L,
   event->GetOrbitalInfo()->GetCutoffSVL());

}
