/*
 * ReprocessTrackAction.cpp
 *
 *  Created on: 23/dic/2009
 *      Author: C. De Santis, N. Mori
 */

#include "ReprocessTrackAction.h"

void ReprocessTrackAction::OnGood(PamLevel2 *event) {

  _allEvents++;

  TrkLevel1 *L1;
  if (_newTrkL1)
    if (_externalFlag)
      if (!(*_externalFlag))
        return;
      else
        L1 = *_newTrkL1; // External L1 plus flag=true
    else
      L1 = *_newTrkL1; // External L1 plus no external flag
  else {
    L1 = (TrkLevel1*) event->GetPointerTo("TrkLevel1"); // Internal L1
    TrkLevel0 *L0 = event->GetTrkLevel0();
    if (!L0) {
      cout << "Missing TrkLevel0 event " << endl;
      return;
    }
    L0->ProcessEvent();// re-processing level0->level1
    L1 = event->GetTrkLevel1();
    L1->Clear();
    L1->SetFromLevel1Struct();
  }

  // See if the event has a track before reprocessing
  TrkLevel2 *trkl2 = event->GetTrkLevel2();
  bool hadTrack = false;
  if (trkl2->GetTrkLevel2()->GetNTracks() > 0)
    hadTrack = true;

  // Reprocess
  _reprocessed++;
  L1->ProcessEvent();// re-processing level1->level2

  trkl2 = event->GetTrkLevel2();
  trkl2->Clear();
  trkl2->SetFromLevel2Struct();

  // See if we gained or lost a track;
  if (trkl2->GetTrkLevel2()->GetNTracks() > 0) {
    if (!hadTrack) {
      _recoveredTracks++;
    }
  }
  else if (hadTrack) {
    _lostTracks++;
  }
}

