/*
 * CaloChi2HistoAction.h
 *
 *  Created on: 04/ago/2009
 *      Author: Nicola Mori
 */

/*! @file CaloChi2HistoAction.h The CaloChi2HistoAction class declaration file. */

#ifndef CALOCHI2HISTOACTION_H_
#define CALOCHI2HISTOACTION_H_

#include "../CollectionAction/CollectionAction.h"
#include "../../CaloAxis2.h"
#include <TH1F.h>
#include <TH2F.h>

/*! @brief An action that fills a CALO Chi2 histogram. The value of Chi2 is obtained from CaloAxis objects. */
class CaloChi2HistoAction: public CollectionAction {
public:

  /*! @brief Constructor.
   *
   * Note that this action does NOT perform the fit of the CALO track, so the fitting procedure must be already done by the
   * CaloAxis objects pointed by xAxis and yAxis.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name.
   * @param xAxis The X axis CaloAxis object.
   * @param yAxis The Y axis CaloAxis object.
   * @param min The lower limit of the histogram's X axis.
   * @param max The upper limit of the histogram's X axis.
   * @param nBins The number of bins.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   */
  CaloChi2HistoAction(const char *actionName, TString outFileName, CaloAxis *xAxis, CaloAxis *yAxis, float min = 0.,
      float max = 1., unsigned int nBins = 100, TString mode = "UPDATE");

  /*! @brief Destructor. */
  ~CaloChi2HistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the histogram to the output ROOT file.*/
  void Finalize();

private:

  TString _outFileName;
  CaloAxis *_xAxis, *_yAxis;
  TString _mode;
  TH1F _xHisto, _yHisto;
  TH2F _xyHisto;
};
#endif /* CALOCHI2HISTOACTION_H_ */
