/*
 * MassVsRigHistoAction.h
 *
 *  Created on: 28-marth-2010
 *      Author: Vitaly Malakhov
 */

/*! @file MassVsRigHistoAction.h The MassVsRigHistoAction class declaration file. */

#include "../Histo2DAction/Histo2DAction.h"

#ifndef MASSVSRIGHISTOACTION_H_
#define MASSVSRIGHISTOACTION_H_

/*! @brief An action that fills a Mass of particle Vs its Rigidity and builds 1D-Mass histoggrams which 
 *         cuts it for rigidities given in an acording file. Mass calculated using input parameter Z.
 *
 */

class MassVsRigHistoAction: public Histo2DAction<Int_t> {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   * @param Z Charge of particle, necessary for calulating mass.
   * @param rigBinFile File included binning for rigidity cut view 1D-Mass histogramm. Uses in finalize function.
   */
  MassVsRigHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot = true, bool outText = true, TString title = "Mass Vs. Rigidity", Int_t Z = 1, TString rigBinFile = "");

  /*! @brief Destructor. */
  ~MassVsRigHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Cuts Mass vs Rigidity 2D histogram into 1D Mass histogramms for rigidity range given in _rigBinFile.
   *
   */
  void Finalize();

private:

Int_t _Z;
vector<TH1F> _fixedRigHisto;
vector<Float_t> _xRBins;
TString _rigBinFile;

};
#endif /* MASSVSRIGHISTOACTION_H_ */
