/*
 * TrkSigmaDeflHistoAction.cpp
 *
 *  Created on: 2009-06-17
 *      Author: S. Ricciarini
 */

/*! @file TrkSigmaDeflHistoAction.cpp The TrkSigmaDeflHistoAction class implementation file. */

#include "TrkSigmaDeflHistoAction.h"

TrkSigmaDeflHistoAction::TrkSigmaDeflHistoAction(const char *actionName, TString outFileBase, TString mode,
    float sigmaDeflFactor, bool outRoot, bool outText, TString title) :
  Histo1DAction<Float_t> (actionName, title, outFileBase, mode, outRoot, outText), _sigmaDeflFactor(sigmaDeflFactor) {
}

void TrkSigmaDeflHistoAction::OnGood(PamLevel2 *event) {

  float sigmaDefl = pow(event->GetTrack(0)->GetTrkTrack()->coval[4][4], 0.5);

  // Bin filling: sigmaDefl must be less than (<) 1/(bin maximum)

  UInt_t i = 0;
  while ((sigmaDefl * _sigmaDeflFactor < 1. / _bins[i + 1]) && (i <= _bins.size() - 1)) { // rigidity bin i maximum = _binning[i+1]. Exit while loop when i exceeds the bin number = _binning.size()-1
    _histo[i]++;
    i++;
  }

}
