/*
 * TofRigPHistoAction.h
 *
 *  Created on: 2009-11-23
 *      Author: S. Ricciarini
 */

/*! @file TofRigPHistoAction.h The TofRigPHistoAction class declaration file. */

#ifndef TOFRIGPHISTOACTION_H_
#define TOFRIGPHISTOACTION_H_

#include "../Histo1DAction/Histo1DAction.h"

/*! @brief An action that fills the histogram: TOF rigidity modulus (from beta measurement) assuming proton mass and charge.
 */
class TofRigPHistoAction: public Histo1DAction<Float_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   * @param outRoot If true, the output file in ROOT format will be produced.
   * @param outText If true, the output file in text format will be produced.
   *             in ROOT's reference guide).
   * @param title The ROOT histogram title.
   * @param trackTof Pointer to an Int_t variable whic stores the number of the Tof Track to be used to compute
   *                 beta. If NULL the standalone track will be used.
   * @param resMax See documentation for ToFLevel2::CalcBeta. Default: 10. (equivalent to beta[12])
   * @param qualCut See documentation for ToFLevel2::CalcBeta. Default: 10. (equivalent to beta[12])
   * @param chi2Cut See documentation for ToFLevel2::CalcBeta. Default: 20. (equivalent to beta[12])
   */
  TofRigPHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot = true,
      bool outText = true, TString title = "Rigidity modulus", Int_t *trackTof = NULL, Float_t resMax = 10.,
      Float_t qualCut = 10., Float_t chi2Cut = 20.) :
    Histo1DAction<Float_t> (actionName, title, outFileBase, mode, outRoot, outText), _trackTof(trackTof), _resMax(
        resMax), _qualCut(qualCut), _chi2Cut(chi2Cut) {
  }

  /*! @brief Destructor */
  ~TofRigPHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:

  Int_t *_trackTof;
  Float_t _resMax, _qualCut, _chi2Cut;

};

#endif /* TOFRIGPHISTOACTION_H_ */
