/*
 * TrkRigHistoAction.h
 *
 *  Created on: 2009-06-05
 *      Author: S. Ricciarini
 *      (Re-edited: 2009-08-25 N. Mori)
 */

/*! @file TrkRigHistoAction.h The TrkRigHistoAction class declaration file. */

#ifndef TRKRIGHISTOACTION_H_
#define TRKRIGHISTOACTION_H_

#include "../Histo1DAction/Histo1DAction.h"

/*! @brief An action that fills the histogram: TRK rigidity (with sign).
 */
class TrkRigHistoAction: public Histo1DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   * @param outRoot If true, the output file in ROOT format will be produced.
   * @param outText If true, the output file in text format will be produced.
   *             in ROOT's reference guide).
   * @param title The ROOT histogram title.
   */
  TrkRigHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot = true,
      bool outText = true, TString title = "Rigidity");

  /*! @brief Destructor */
  ~TrkRigHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

};

#endif /* TRKRIGHISTOACTION_H_ */
