/*
 * CaloTrackCut.cpp
 *
 *  Created on: 17-mar-2009
 *      Author: S: Ricciarini
 */

/*! @file CaloTrackCut.cpp The CaloTrackCut class implementation file */

#include "CaloTrackCut.h"

int CaloTrackCut::Check(PamLevel2 *event) {

  // NOTE: FitAxis(L1 calo tree, axis, tolerance) method finds the X (Y) axis projection of the track into the calorimeter, by excluding clusters which are far away from the main X (Y) clustering area
  // NOTE: axis=0 => X, axis=1 => Y; tolerance in cm

  Float_t rcil;
  xCaloAxis.Reset();
  yCaloAxis.Reset();
  
  if (_showerFit) { // shower fit
    rcil=1.; // tolerance (cm)
    if ( !(xCaloAxis.FitShower(event->GetCaloLevel1(), 0, rcil) ) || !(yCaloAxis.FitShower(event->GetCaloLevel1(), 1, rcil) ) ) {
      return 0;
    }
  }
  else { // single-track fit
    rcil=1.; // tolerance (cm) 
    if ( !(xCaloAxis.FitAxis(event->GetCaloLevel1(), 0, rcil) ) || !(yCaloAxis.FitAxis(event->GetCaloLevel1(), 1, rcil) ) ) {
      return 0;
    }
  }
  
  // NOTE: chi2 must be positive for the track to be meaningful
  if ( !(xCaloAxis.GetChi2() > 0 ) || !(yCaloAxis.GetChi2() > 0) ) {
    return 0; // check that the track is meaningful
  }

  return CUTOK;
}
