/*
 * CaloTrackChi2Cut.cpp
 *
 *  Created on: 18-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file CaloTrackChi2Cut.cpp The CaloTrackChi2Cut class implementation file */

#ifndef NO_CALOAXIS

#include "CaloTrackChi2Cut.h"

int CaloTrackChi2Cut::Check(PamLevel2 *event) {

  float xChi2 = _xCaloAxis->GetChi2();
  float yChi2 = _yCaloAxis->GetChi2();

  if (!(_minChi2 < xChi2 && xChi2 < _maxChi2 && _minChi2 < yChi2 && yChi2 < _maxChi2)) {
    return 0;
  }
  
  return CUTOK;

}

#endif /* NO_CALOAXIS */
