/*
 * CaloQtotCut.h
 *
 *  Created on: 10-mar-2019
 *      Author: S. Ricciarini
 */

/*! @file CaloQtotCut.h The CaloQtotCut class definition file */

#ifndef CALOQTOTCUT_H_
#define CALOQTOTCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief Cut on Calo Qtot variable. Events are discared if not inside the chosen interval of Qtot (total charge in calorimeter)
 */

class CaloQtotCut: public PamCut {

public:
  /*! @brief The calorimeter Qtot cut.
   * @param cutName The name of the cut.
   * @param qTotMin The minimum threshold for qtot (default: 0).
   * @param qTotMax The minimum threshold for qtot (default: 1000000000).
   */
  CaloQtotCut(const char *cutName, Float_t qTotMin=0., Float_t qTotMax=1000000000.) :
    PamCut(cutName), _qTotMin(qTotMin), _qTotMax(qTotMax) {
  }

  /*! @brief Destructor. */
  ~CaloQtotCut() {
  }

  /*! @brief The non-interacting track check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the ratio between the charge released along the track
   *                and the total released charge is greater than qRatioMin.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  Float_t _qTotMin, _qTotMax;

};
#endif /* CALOQTOTCUT_H_ */
