/*
 * CaloNucleiZCut.cpp
 *
 *  Created on: 30-apr-2009
 *      Author: Nicola Mori
 */

/*! @file CaloNucleiZCut.cpp The CaloNucleiZCut class implementation file */

#ifndef NO_CALONUCLEI

#include "CaloNucleiZCut.h"

const float CaloNucleiZCut::_sigmaZ[] = { 0.11, 0.14, 0.21, 0.28, 0.28, 0.31, 0.32, 0.32 }; // the charge-width in a layer for Z=1..8

int CaloNucleiZCut::Check(PamLevel2 *event) {

  if (_Z < 1 || _Z > 8)
    return CALONUCLEIZ_ILLEGALZ;

  // Check if CaloNuclei has already been initialized
  if (_caloNuclei == NULL)
    _caloNuclei = new CaloNuclei(event);

  // Obtain charge
  Float_t charge;
  switch (_method) {
  case CALONUCLEIZ_SIEGEN:
    charge = _caloNuclei->Get_charge_siegen1();
    break;
  case CALONUCLEIZ_DEDXBETA:
    charge = _caloNuclei->Get_ZCalo_dedx_b();
    break;
  case CALONUCLEIZ_DEDXDEFL:
    charge = _caloNuclei->Get_ZCalo_dedx_defl();
    break;
  }

  // Check
  if ((charge > _Z + _upperLimit * _sigmaZ[_Z - 1]) || (charge < _Z - _lowerLimit * _sigmaZ[_Z - 1])) {
    return CALONUCLEIZ_OUTOFBOUNDS;
  }

  return CUTOK;

}

#endif /* NO_CALONUCLEI */
