/*
 * CaloNotIntCut.cpp
 *  Created on: 17-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file CaloNotIntCut.cpp The CaloNotIntCut class implementation file */

#include "CaloNotIntCut.h"

int CaloNotIntCut::Check(PamLevel2 *event) {

  if ( (!(_xCaloAxis) || !(_yCaloAxis)) && !(_trkTrack) ) { // check that one of the two possible initializations has been correctly done
    return 0;
  }
  
  if (!(_trkTrack)) { // CALO track
  
    // energy released along the event axis in the calo / total energy release in the calo
    
    float qratio = ( _xCaloAxis->GetQaxis() + _yCaloAxis->GetQaxis() ) / event->GetCaloLevel2()->qtot;

    if (! (qratio > _qRatioMin) ) {
      return 1;
    }
  
  }
  
  if (_trkTrack) { // TRK track
  
   return 2; // temporary
    // Implement here the check using the tracker track.

  }

  return CUTOK;
  
}
