/*
 * CaloNHitCut.cpp
 *
 *  Created on: 18-mar-2009
  *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file CaloNHitCut.cpp The CaloNHitCut class implementation file */

#ifndef NO_CALOAXIS

#include "CaloNHitCut.h"

int CaloNHitCut::Check(PamLevel2 *event) {

  int nHit;

  // Check X
  
  nHit=0;
  for (unsigned int ipl=0; ipl<22; ipl++) {
    if (_xCaloAxis->GetQ(ipl) > 0) {
      nHit++;
    }
  }

  if (nHit < _nMinHit) {
    return 0;
  }

  // Check Y
  nHit = 0;
  for (unsigned int ipl=0; ipl<22; ipl++) {
    if (_yCaloAxis->GetQ(ipl) > 0) {
      nHit++;
    }
  }

  if (nHit < _nMinHit) {
    return 0;
  }

  return CUTOK;

}

#endif /* NO_CALOAXIS */
