/*
 * CaloGeomCut.cpp
 *
 *  Created on: 19-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file CaloGeomCut.cpp The CaloCrossCut class implementation file */

#include "CaloGeomCut.h"

int CaloGeomCut::Check(PamLevel2 *event) {

  float xCaloTrack;
  float yCaloTrack;

  for (Int_t igf = 0; igf < TrkParams::nGF; igf++) {
    xCaloTrack = _xCaloAxis->par[0] + (_xCaloAxis->par[1]) * TrkParams::zGF[igf]; // cm
    if (! (TrkParams::xGF_min[igf] + _xTolCaloTrack < xCaloTrack && xCaloTrack < TrkParams::xGF_max[igf]
        - _xTolCaloTrack) ) {
      return 0;
    }

    yCaloTrack = _yCaloAxis->par[0] + (_yCaloAxis->par[1]) * TrkParams::zGF[igf]; // cm
    if (! (TrkParams::yGF_min[igf] + _yTolCaloTrack < yCaloTrack && yCaloTrack < TrkParams::yGF_max[igf]
        - _yTolCaloTrack) ) {
      return 0;
    }
  }

  return CUTOK;
}
