/*
 * CaloAngleCut.cpp
 *
 *  Created on: 11-jan-2010
 *      Author: S. Ricciarini
 */

/*! @file CaloAngleCut.cpp */
#ifndef NO_CALOAXIS

#include "CaloAngleCut.h"

int CaloAngleCut::Check(PamLevel2 *event) {

  static const double pi = 3.14159265;
  Double_t xAngle;

    xAngle = atan(_xCaloAxis->par[1])*180/pi; // par[1]=tg(theta) . xAngle expressed in degrees
    if (! (_minXAngle < xAngle && xAngle < _maxXAngle) ) {
      return 0;
    }

  return CUTOK;
}

#endif /* NO_CALOAXIS */
