/*
 * CaloCuts.h
 *
 *  Created on: 15-mag-2009
 *      Author: Nicola Mori
 */

/*! @file CaloCuts.h This header contains the inclusion of all Calo cuts. */

#ifndef CALOCUTS_H_
#define CALOCUTS_H_

#include "CaloAngleCut/CaloAngleCut.h"         // Impact angle in the calorimeter
#include "CaloCrossCut/CaloCrossCut.h"         // Calorimeter last plane cross
#include "CaloGeomCut/CaloGeomCut.h"           // Fiducial acceptance with calorimeter's track
#include "CaloGeomYSensCut/CaloGeomYSensCut.h" // Y sensor check
#include "CaloIonCut/CaloIonCut.h"             // Ionization in the first calo plane
#include "CaloNHitCut/CaloNHitCut.h"           // Number of hit strips in the calorimeter
#include "CaloNotIntCut/CaloNotIntCut.h"       // Non-interacting particle in calorimeter
#include "CaloNucleiZCut/CaloNucleiZCut.h"     // Particle's charge cut based on CaloNuclei
#include "CaloQtotCut/CaloQtotCut.h"           // Total energy
#include "CaloTrackChi2Cut/CaloTrackChi2Cut.h" // Chi2 quality for calo track
#include "CaloTrackCut/CaloTrackCut.h"         // Calorimeter track

#endif /* CALOCUTS_H_ */
