/*
 * CaloIonCut.cpp
 *
 *  Created on: 19-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file CaloIonCut.cpp The CaloCrossCut class implementation file */

#include "CaloIonCut.h"

int CaloIonCut::Check(PamLevel2 *event) {

  float q_xcaltrack_fp = 0., q_ycaltrack_fp = 0.; // Q for first plane with Q along the track larger than 0

  for (unsigned int ipl=0; ipl<22; ipl++) {
    if (_xCaloAxis->GetQ(ipl) > 0) {
      q_xcaltrack_fp=_xCaloAxis->GetQ(ipl);
      break;
    }
  }

  for (unsigned int ipl=0; ipl<22; ipl++) {
    if (_yCaloAxis->GetQ(ipl) > 0) {
      q_ycaltrack_fp=_yCaloAxis->GetQ(ipl);
      break;
    }
  }

  if (! (_minRelease < q_xcaltrack_fp && q_xcaltrack_fp < _maxRelease &&
         _minRelease < q_ycaltrack_fp && q_ycaltrack_fp < _maxRelease) ) {
    return 0;
  }

  return CUTOK;

}
