/*
 * CaloTrackCut.h
 *
 *  Created on: 17-mar-2009
 *      Author: Nicola Mori
 */

/*! @file CaloTrackCut.h The CaloTrackCut class definition file */

#ifndef CALOTRACKCUT_H_
#define CALOTRACKCUT_H_

#include "../../PamCutBase/PamCutBase.h"
#include "../../CaloAxis2.h"

/*! @brief The calorimeter track cut.
 * Checks for the existence of a track in the calorimeter, using the CaloAxis routine.
 * WARNING: Check() assumes that level 1 data for the calorimeter exists.
 */

class CaloTrackCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  CaloTrackCut(const char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~CaloTrackCut() {
  }

  /*! @brief The calorimeter track check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if it is possible to identify a meaningful (chi2 > 0) track in the calorimeter.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

  /*!@{*/
  /*! @brief The CaloAxis objects for the last track.
   * These objects stores information about the track of the last examined event.
   */
  CaloAxis xCaloAxis;
  CaloAxis yCaloAxis;
  /*!@}*/
};

#endif /* CALOTRACKCUT_H_ */
