/*
 * CaloNotIntCut.cpp
 *  Created on: 17-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file CaloNotIntCut.cpp The CaloNotIntCut class implementation file */

#include "CaloNotIntCut.h"

int CaloNotIntCut::Check(PamLevel2 *event) {

  if ( (!(_xCaloAxis) || !(_yCaloAxis)) && !(_pamTrack) ) { // check that one of the two possible initializations has been correctly done
    return 0;
  }
  
  if (!(_pamTrack)) { // CALOAXIS track
  
    // energy released along the event axis in the calo / total energy release in the calo
    
    Double_t qtot = event->GetCaloLevel2()->qtot;
    if ( qtot>0 ) {
    
      Double_t qratio = ( _xCaloAxis->GetQaxis() + _yCaloAxis->GetQaxis() ) / qtot;

      if (! (qratio > _qRatioMin) ) {
        return 1;
      }
  
    }
  }
  
  if (_pamTrack) { // PAMELA track

    Double_t qtot = event->GetCaloLevel2()->qtot;
    if ( qtot>0 ) {

      Double_t qratio = ( (*_pamTrack)->GetCaloTrack()->qtrack ) / qtot;

      if (! (qratio > _qRatioMin) ) {  
        return 2;
      }
      
    }

  }

  return CUTOK;
  
}
