/*
 * CaloCrossCut.h
 *
 *  Created on: 19-mar-2009
 *      Author: Nicola Mori
 */

/*! @file CaloCrossCut.h The CaloCrossCut class definition file */

#ifndef CALOCROSSCUT_H_
#define CALOCROSSCUT_H_

#include "../../PamCutBase/PamCutBase.h"
#include "../../CaloAxis2.h"

/*! @brief The calorimeter last plane cut.
 *
 * Checks if the particle has crossed the last calorimeter plane. The current
 * implementation uses the CaloAxis objects; to save computing time, the class
 * assumes that the track is externally computed for each event and stored in
 * CaloAxis objects; pointers to these objects are passed as arguments to the constructor.
 * The Check method will then ignore the PamLevel2 *event and assume that the
 * current content of the CaloAxis objects are relative to the current event.
 * It is an user's task to ensure that these assumptions are fulfilled every time
 * Check or ApplyCut are called.
 *
 * CUT DEPENDENCIES: CaloTrackCut for the existence of the track (it can also provide the CaloAxis objects).
 */

class CaloCrossCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * The CaloAxis arguments are pointers to objects which contain the calorimeter
   * track information for current event.
   *
   * @param cutName The cut name.
   * @param xCaloAxis The pointer to the CaloAxis object for X axis.
   * @param yCaloAxis The pointer to the CaloAxis object for Y axis.
   */
  CaloCrossCut(const char *cutName, CaloAxis *xCaloAxis, CaloAxis *yCaloAxis) :
    PamCut(cutName), _xCaloAxis(xCaloAxis), _yCaloAxis(yCaloAxis){
  }
  /*! @brief Destructor. */
  ~CaloCrossCut() {
  }

  /*! @brief The calorimeter last plane check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if charge released in plane 22 is greater than 0 (from CaloAxis) for both X and Y
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

private:
  CaloAxis *_xCaloAxis, *_yCaloAxis;
};

#endif /* CALOCROSSCUT_H_ */
