/*
 * CASCut.h
 *
 *  Created on: 13-may-2011
 *      Author: Sergio Ricciarini
 */

/*! @file CASCut.h The CASCut class definition file */

#ifndef CASCUT_H_
#define CASCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The CAS cut.
 * An event survives this cut only if no CAS scintillator has signal.
 */

class CASCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  CASCut(const char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~CASCut() {
  }

  /*! @brief The CAS check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if all the CAS scintillators show no signal
   * @return 0 if there's a signal on at least one scintillator
   */
  int Check(PamLevel2 *event);
};
#endif /* CASCUT_H_ */
