/*
 * CATCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori
 */

/*! @file CATCut.h The CATCut class definition file */

#ifndef CATCUT_H_
#define CATCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The CAT cut.
 * An event survives this cut only if no CAT scintillator has signal.
 */

class CATCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  CATCut(const char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~CATCut() {
  }

  /*! @brief The CAT check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if all the CAT scintillators show no signal
   * @return 0 if there's a signal on at least one scintillator
   */
  int Check(PamLevel2 *event);
};
#endif /* CATCUT_H_ */
