/*
 * CARDCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori
 */

/*! @file CARDCut.h The CARDCut class definition file */

#ifndef CARDCUT_H_
#define CARDCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The CARD cut.
 * An event survives this cut only if no CARD scintillator has signal.
 */

class CARDCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  CARDCut(const char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~CARDCut() {
  }

  /*! @brief The CARD check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if all the CARD scintillators show no signal
   * @return 0 if there's a signal on at least one scintillator
   */
  int Check(PamLevel2 *event);
};
#endif /* CARDCUT_H_ */
