/*
 * TrkGeomCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: N. Mori, S. Ricciarini
 */

/*! @file TrkGeomCut.h The TrkGeomCut class definition file */

#ifndef TRKGEOMCUT_H_
#define TRKGEOMCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker fiducial acceptance cut.
 * This cut checks if the track is inside the fiducial acceptance chosen for the tracker.
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */

class TrkGeomCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * The parameters are the width of the regions on each side of a view that define the
   * fiducial acceptance region. The detector size is therefore reduce by an amount of xTol
   * (yTol) on each side of the X (Y) view for all the GF planes except fot M1 and M2. For these,
   * xMagnTol and yMagnTol will be used as parameters.
   *
   * @param cutName The cut's name.
   * @param trkAlg        The tracking algorythm used to check the track.
   * @param xTol The fiducial border on X view for a generic plane in cm (except M1 and M2).
   * @param yTol The fiducial border on Y view for a generic plane in cm (except M1 and M2).
   * @param xMagnTol The fiducial border on X view for M1 and M2 in cm.
   * @param yMagnTol The fiducial border on Y view for M1 and M2 in cm.
   */
  TrkGeomCut(const char *cutName, const char *trkAlg, Float_t xTol=0.15, Float_t yTol=0.15, Float_t xMagnTol=0.15, Float_t yMagnTol=0.15) :
    PamCut(cutName), _trkAlg(trkAlg), _xTol(xTol), _yTol(yTol), _xMagnTol(xMagnTol), _yMagnTol(yMagnTol) {
  }
  /*! @brief Destructor. */
  ~TrkGeomCut() {
  }

  /*! @brief The tracker fiducial acceptance check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the track is inside the fiducial acceptance.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);




private:

  const char *_trkAlg;
  Float_t _xTol, _yTol;
  Float_t _xMagnTol, _yMagnTol;

};
#endif /* TRKGEOMCUT_H_ */
