/*
 * TofBetaRigHCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofBetaRigHCut.cpp The TofBetaRigHCut class implementation file */

#include "TofBetaRigHCut.h"

int TofBetaRigHCut::Check(PamLevel2 *event) {

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

  Int_t seqno = trkTrack->GetSeqNo();
  Int_t ntrack_tof = 0;
  for (Int_t i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
    if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == seqno)
      ntrack_tof = i;
  }
  Float_t betaModTof = fabs(event->GetToFLevel2()->CalcBeta(ntrack_tof, 10., 10., 20.)); // beta[12]

  //  Float_t rigMod = _mass*fabs(beta)*pow((1-pow(beta,2)),-0.5)/abs(_charge);

  Int_t _charge=1;
  Float_t _mass_p=0.93827203; // GeV (pdg.web.cern.ch)
  Float_t _mass_d=1.99846; // GeV (www.nndc.bnl.gov)

  Float_t betaModTrk_p = (trkTrack->GetRigidity() * abs(_charge)) / pow(pow(trkTrack->GetRigidity() * _charge, 2) + pow(
      _mass_p, 2), 0.5);

  Float_t betaModTrk_d = (trkTrack->GetRigidity() * abs(_charge)) / pow(pow(trkTrack->GetRigidity() * _charge, 2) + pow(
      _mass_d, 2), 0.5);

  if ( (fabs(betaModTof - betaModTrk_p) > _threshold * betaModTof) && (fabs(betaModTof - betaModTrk_d) > _threshold * betaModTof) ) {
    return 0;
  }

  return CUTOK;
}
