/*
 * VerboseCollection.cpp
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file VerboseCollection.cpp The VerboseCollection class implementation file */

#include "VerboseCollection.h"
#include <cmath>

void VerboseCollection::Finalize() {

  // Prepare the output format
  streamsize oldPrec = cout.precision();
  streamsize newPrec = 4;
  cout.precision(newPrec);
  cout.setf(ios::fixed, ios::floatfield);
  unsigned int nDigitsEvents = 0;
  double nEvents = (double) GetNEv();
  while (nEvents >= 1.) {
    nEvents /= 10.;
    nDigitsEvents++;
  }
  unsigned int nameWidth = 0;

  for (unsigned int i = 0; i < _cuts.size(); i++) {
    if (strlen(GetCut(i)->GetName()) > nameWidth)
      nameWidth = strlen(GetCut(i)->GetName());
  }
  for (unsigned int i = 0; i < _actions.size(); i++) {
    if (strlen(GetAction(i)->GetName()) > nameWidth)
      nameWidth = strlen(GetAction(i)->GetName());
  }
  cout << "\n- Collection: " << GetName() << "\n";
  cout << "  Selected/Analized events (eff.): " << GetNGood() << "/" << GetNEv() << "  ("
      << (float) GetNGood() / (float) GetNEv() << ")\n";
  cout << "     " << setw(nameWidth + 1) << "--Single cuts--";
  cout << "     " << setw(nDigitsEvents) << "sel.";
  cout << "     " << setw(nDigitsEvents) << "tot.";
  cout << "     " << setw(newPrec + 2) << "eff.";
  cout << "     " << setw(newPrec + 2) << "prog. eff.\n";

  // Print the names of the actions placed before the cuts
  unsigned int iAction = 0;
  if (_actions.size() > 0) {
    while (_actionsPositions[iAction] == -1) {
      cout << "     " << setw(nameWidth) << _actions[iAction]->GetName() << ":" << "                   ACTION\n";
      iAction++;
      if (iAction == _actions.size())
        break;
    }
  }

  for (unsigned int iCut = 0; iCut < GetSize(); iCut++) {
    cout << "     " << setw(nameWidth) << GetCut(iCut)->GetName() << ":";
    cout << "     " << setw(nDigitsEvents) << GetCut(iCut)->GetNGood();
    cout << "     " << setw(nDigitsEvents) << GetCut(iCut)->GetNEv();
    cout << "     " << (float) GetCut(iCut)->GetNGood() / (float) GetCut(iCut)->GetNEv();
    cout << "     " << (float) GetCut(iCut)->GetNGood() / (float) GetNEv();
    cout << "\n";

    if (iAction < _actions.size()) {
      while (_actionsPositions[iAction] == (int) iCut) {
        cout << "     " << setw(nameWidth) << _actions[iAction]->GetName() << ":                   ACTION\n";
        iAction++;
        if (iAction == _actions.size())
          break;
      }
    }
  }
  cout << endl;

  // Reset the output format
  cout.precision(oldPrec);
  cout << resetiosflags(ios::floatfield);

  SmartCollection::Finalize();

}
