/*
 * EvRateS11VsCutoffHistoAction.cpp
 *
 *  Created on: 21-mag-2009
 *      Author: Nicola Mori
 */

/*! @file EvRateS11VsCutoffHistoAction.cpp The EvRateS11VsCutoffHistoAction class implementation file. */

#include "EvRateS11VsCutoffHistoAction.h"

EvRateS11VsCutoffHistoAction::EvRateS11VsCutoffHistoAction(const char *actionName, TString outFileName, TString mode) :
  CollectionAction(actionName), _outFileName(outFileName), _histo(), _mode(mode) {

  _histo.SetName(GetName());
  _histo.SetTitle("Event rate on S11 Vs. Stoermer cutoff");
  _histo.GetXaxis()->SetTitle("Stoermer cutoff (GV)");
  _histo.GetYaxis()->SetTitle("Event rate on S11 (Hz)");
  _histo.SetBins(100, 0., 16., 1000, 0., 4000.);
}

void EvRateS11VsCutoffHistoAction::OnGood(PamLevel2 *event) {

  int totRate = 0;
  for (int i = 0; i < 16; i++)
    totRate += event->GetTrigLevel2()->pmtcount1[i];
  _histo.Fill(event->GetOrbitalInfo()->GetCutoffSVL(), (float) totRate / 16.);

}

void EvRateS11VsCutoffHistoAction::Finalize() {

  TFile outFile(_outFileName, _mode);
  outFile.cd();
  _histo.Write();
  outFile.Close();
}
