/*
 * TofBetaRangeCut.cpp
 *
 *  Created on: 10-apr-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofBetaRangeCut.cpp The TofBetaRangeCut class implementation file */

#include "TofBetaRangeCut.h"

int TofBetaRangeCut::Check(PamLevel2 *event) {

//    float _beta = 0.;
//  cout << _trackTof <<endl;

    if(!event->GetToFLevel2())return 0;

    ToFTrkVar *trackTof = NULL;

    if(_trkId<0 ){
	trackTof = event->GetToFLevel2()->GetToFStoredTrack(_trkId); //standalone      
    }else{
	if( event->GetNTracks(_trkAlg) <= _trkId ){
	    cout << "TofBetaRangeCut: trk.ID = "<<_trkId<<", trk.ALG = "<<_trkAlg<<" _BUT_ n.tracks = "<<event->GetNTracks(_trkAlg)<<endl;
	    cout << "TofBetaRangeCut: inconsistent cut!!!"<<endl;
	    return 0;
	}
	trackTof = event->GetTrack(_trkId,_trkAlg)->GetToFTrack();
    }

    if(!trackTof){
	cout << "TofBetaRangeCut: ToFTrkVar obj pt = "<<trackTof<<endl;      
	return 0;
    }
///////////////////////////

    beta = trackTof->CalcBeta(_resMax,_qualCut,_chi2Cut);


    if( ! (_minBeta < beta && beta < _maxBeta) ) {
	return 0;
    }

    return CUTOK;
  
}
