/*
 * TrkDedxVsBetaHistoAction.cpp
 *
 *  Created on: 9-giu-2009
 *      Author: Nicola Mori
 */

/*! @file TrkDedxVsBetaHistoAction.cpp The TrkDedxVsBetaHistoAction class implementation file. */

#include "TrkDedxVsBetaHistoAction.h"

TrkDedxVsBetaHistoAction::TrkDedxVsBetaHistoAction(const char *actionName, TString outFileBase, TString mode,
    int whichBeta, bool outRoot, bool outText, TString title) :
  Histo2DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText), _whichBeta(whichBeta) {

}

void TrkDedxVsBetaHistoAction::OnGood(PamLevel2 *event) {

  float beta = 0;
  if (_whichBeta == BETA12)
    beta = event->GetTrack(0)->GetToFTrack()->beta[12];
  else if (_whichBeta == BETABEST)
    beta = event->GetToFLevel2()->CalcBeta(event->GetTrack(0)->GetToFTrack()->trkseqno, 3.0, 20.0, 3.0);
  else if (_whichBeta == BETA12_STANDALONE)
    beta = event->GetToFLevel2()->CalcBeta(0, 10.0, 10.0, 20.0);
  else if (_whichBeta == BETABEST_STANDALONE)
      beta = event->GetToFLevel2()->CalcBeta(0, 3.0, 20.0, 3.0);

  Fill(beta, event->GetTrack(0)->GetTrkTrack()->GetDEDX());
}
