/*
 * GPYVsXT2HistoAction.cpp
 *
 *  Created on: 01/jun/2010
 *      Author: Sergio Ricciarini
 */

/*! @file GPYVsXT2HistoAction.cpp The GPYVsXT2HistoAction class implementation file. */

#include "GPYVsXT2HistoAction.h"

GPYVsXT2HistoAction::GPYVsXT2HistoAction(const char *actionName, TString outFileBase, TString mode,
    bool outRoot, bool outText, TString title) :
  Histo2DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText) {

  SetXAxis("X (cm)",100,TrkParams::xGF_min[6],TrkParams::xGF_max[6]); // Default X axis for T2 (igf=6)
  SetYAxis("Y (cm)",100,TrkParams::yGF_min[6],TrkParams::yGF_max[6]); // Default Y axis for T2 (igf=6)
  
}

void GPYVsXT2HistoAction::OnGood(PamLevel2 *event) {

  for(Int_t h=0; h<=event->GetGPamela()->Nthspe; h++) {
    if (event->GetGPamela()->Iparspe[h] < 100) { // primary particle (NOTE: 100)
    if (event->GetGPamela()->Itrpb[h] == 2) { // hit TRK plane (1 to 6)    
      Float_t x = (event->GetGPamela()->Xinspe[h]+event->GetGPamela()->Xoutspe[h])/2.;
      Float_t y = (event->GetGPamela()->Yinspe[h]+event->GetGPamela()->Youtspe[h])/2.;
    
      Fill(x,y);

      break;
    }
    }
  }

}
