/*
 * EvRateS11VsBabsHistoAction.cpp
 *
 *  Created on: 10-jun-2009
 *      Author: Nicola Mori
 */

/*! @file EvRateS11VsBabsHistoAction.cpp The EvRateS11VsBabsHistoAction class implementation file. */

#include "EvRateS11VsBabsHistoAction.h"

EvRateS11VsBabsHistoAction::EvRateS11VsBabsHistoAction(const char *actionName, TString outFileName, TString mode) :
  CollectionAction(actionName), _outFileName(outFileName), _histo(), _mode(mode) {

  _histo.SetName(GetName());
  _histo.SetTitle("Event rate on S11 Vs. Geomagnetic field");
  _histo.GetXaxis()->SetTitle("Magnetic field (gauss)");
  _histo.GetYaxis()->SetTitle("Event rate on S11 (Hz)");
  _histo.SetBins(100, 0., 1., 100, 0., 4000.);
}

void EvRateS11VsBabsHistoAction::OnGood(PamLevel2 *event) {

  int totRate = 0;
  for (int i = 0; i < 16; i++)
    totRate += event->GetTrigLevel2()->pmtcount1[i];
  _histo.Fill(event->GetOrbitalInfo()->Babs, (float) totRate / 16.);

}

void EvRateS11VsBabsHistoAction::Finalize() {

  TFile outFile(_outFileName, _mode);
  outFile.cd();
  _histo.Write();
  outFile.Close();
}
