/*
 * LiveTimeCollection.h
 *
 *  Created on: 30-marth-2010
 *      Author: Vitaly Malakhov
 */

/*! @file LiveTimeCollection.h The LiveTimeCollection class definition file */

#ifndef LIVETIMECOLLECTION_H_
#define LIVETIMECOLLECTION_H_

#include "../SmartCollection/SmartCollection.h"
/*! @brief A collection which calculate a sum of live time of all events not survived cuts before an action
 * and change live time of an event survived all cuts for the sum live time before apply OnGood method.
 * That mean that if an action deals with LiveTime then it will use not just live time of last survived events
 * but of all events having not survived all cuts before the action. For each action sum of live time is calculated
 * independently since it may be differ from each other. It is recomended to add LiveTime collection
 * as a cut to for example Smart collection object after adding LTQualCut(), DataQualCut("",TRG) and cuts selected
 * geographical regions.
 */
class LiveTimeCollection: public SmartCollection {

public:

  /*! @brief Constructor.
   *
   * @param collectionName The collection's name.
   * @param owns If true, the collection will own the cuts and the actions, ie., it will
   *             destroy them in its destructor.
   * @param livetimereport File were report of Live Time analysis will be written
   */
  LiveTimeCollection(const char *collectionName, bool owns = true, TString livetimereport = "./livetimereport.txt") :
    SmartCollection(collectionName, owns), _currenttime(0), _livetimereport(livetimereport) {
  }

  /*! @brief Destructor. */
  ~LiveTimeCollection() {
  }

  /*! @brief Adds an action to the SmartCollection */
  void AddAction(CollectionAction *action);

  /*! @brief This method increase live time counter if event haven't survive a cut.
   * 
   */
  void OnBad(PamLevel2 *event, int actNumber, unsigned int inc);

  /*! @brief Return general live time counter for actNumber'th action  */
  Float_t GetSumLiveTime(unsigned int actNumber);

  /*! @brief Applies cut like it is done in SmartCollection::AplyCut but also before apply OnGood method 
   *  it change live time of an event survived all cuts for live time which is the sum of live times 
   *  of all event having not survived all cuts before the action.
   */
  int ApplyCut(PamLevel2 *event);

  /*! @brief Write report file */
  void Finalize();

private:

  std::vector<UInt_t> _sumLT;
  UInt_t _currenttime;
  TString _livetimereport;

protected:

  std::vector<UInt_t> _sum;

};

#endif /* LIVETIMECOLLECTION_H_ */
