/*
 * TrkSigmaDeflCut.cpp
 *
 *  Created on:23-apr-2009
 *      Author: S. Ricciarini
 */

/*! @file TrkSigmaDeflCut.cpp The TrkRigGeoCut class implementation file */

#include "TrkSigmaDeflCut.h"

TrkSigmaDeflCut::TrkSigmaDeflCut(const char *cutName, const char* rigBinListFileName) :
    PamCut(cutName), _binning(0) {

    ifstream rigBinList;
    rigBinList.open(rigBinListFileName);
    TString bin;

    while (!rigBinList.eof()) {
      rigBinList >> bin;
      if (bin != "") {
        _binning.push_back(bin.Atof());
#ifdef DEBUGPAMCUT
        cout << "Bin: " << bin.Atof() << endl;
#endif
      }
    }

    rigBinList.close();

#ifdef DEBUGPAMCUT
    cout << "\nNumber of bins: " << _binning.size() << endl;
#endif
  }

int TrkSigmaDeflCut::Check(PamLevel2 *event) {

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

  float sigmaDefl = pow(trkTrack->coval[4][4],0.5);
  float rigMod = trkTrack->GetRigidity();

//  cout << "sigmaDefl: " << sigmaDefl << endl;
//  cout << "rigMod: " << rigMod << endl;

  // check on overall binning interval
  if (rigMod >= _binning[_binning.size() - 1] || rigMod < _binning[0]) {
    return 0;
  }

  //Bin upper limit identification: after this loop, the bin containing rigMod is defined as (_binning[i-1] , _binning[i])
  int i = 1;
  while (_binning[i] < rigMod) {
    i++;
  }

//  cout << "binmax: " << _binning[i] << endl;

  if ( ! ( sigmaDefl < 1./_binning[i]) ) { // required condition: sigma_defl < |defl_min(bin)| = 1./|rig_max(bin)| = 1./_binning[i]
    return 1;
  }

//  cout << "OK" << endl;
//  cout << endl;

  return CUTOK;
}
