/*
 * TofBetaCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TofBetaCut.h The TofBetaCut class definition file */

#ifndef TOFBETACUT_H_
#define TOFBETACUT_H_

#include "../../PamCutBase/PamCutBase.h"


/*! @brief The TofBeta cut.
 * This cut ensures that beta (referred to a specified track) has been calculated
 *
 */

class TofBetaCut: public PamCut {

public:

  /*! @brief Constructor.
  * The parameters are: the TOF-index for the track which is necessary to input to derive the beta and (resMax, qualCut and chi2Cut) for the quality of beta. Various combinations of quality parameters are possible: default low-quality beta (used for beta[12]): 10.,10.,20.; medium-quality beta: 5.,15.,4.; high-quality beta: 3.,20.,3.
  *
  * @param cutName The cut's name.
  * @param trackTof Pointer to the TOF-index indicating the track to be used when evaluating
  *        the beta (default value for TOF_index is 0, corresponding to the TOF stand-alone
  *        track [no TRK information to build the TOF stand-alone track]). The pointer to the
  *        TOF_index for TRK-track as given by TrkPhSinCut can be used.
  *
  * @param resMax Default: 10. (equivalent to beta[12])
  * @param qualCut Default: 10. (equivalent to beta[12])
  * @param chi2Cut Default: 20. (equivalent to beta[12])
  */
  TofBetaCut(const char *cutName, int *trackTof=NULL, float resMax=10., float qualCut=10., float chi2Cut=20.):
    PamCut(cutName), _trackTof(trackTof), _resMax(resMax), _qualCut(qualCut), _chi2Cut(chi2Cut) {
  }
  /*! @brief Destructor. */
  ~TofBetaCut() {
  }

  /*! @brief The TofBeta check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if beta ("high quality") has been calculated
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

  float beta; ///< The beta value for the last examined event.

private:

  int *_trackTof;

  float _resMax, _qualCut, _chi2Cut;

};

#endif /* TOFBETACUT_H_ */
