/*
 * CommonDefs.h
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */

/*! @file CommonDefs.h A header file with all the common definitions for the PamCut framework.
 */

#ifndef COMMONDEFS_H_
#define COMMONDEFS_H_

/*! @brief The implementations of PamCut::Check() must return this value if the event satisfy the cut*/
const int CUTOK = -1;

/*! @enum DETECTORCODE
 * The values for each detector correspond to a binary code associated to that detector.
 * These can be arithmetically added to create a binary code for a set of detectors.
 */
enum DETECTORCODE {
  TRK = 1, ///< Code for Tracker
  CALO = 2, ///< Code for Calorimeter
  TOF = 4, ///< Code for ToF
  AC = 8, ///< Code for AntiCoincidence
  TRIG = 16, ///< Code for Trigger
  ORB = 32, ///< Code for Orbital Info
  ALL = 63 ///< Code for All the detectors
};

#endif /* COMMONDEFS_H_ */
