/*
 * ReprocessCaloAction.h
 *
 *  Created on: 10/mar/2010
 *      Author: Nicola Mori
 */

#ifndef NO_CALOPRESAMPLER

#ifndef REPROCESSCALOACTION_H_

#define REPROCESSCALOACTION_H_
#include "../CollectionAction/CollectionAction.h"
#include <CaloPreSampler.h>

/*! @brief Calorimeter reprocessing
 *
 * This action reprocesses the calorimeter data. It needs CaloPreSampler, so make sure
 * it is available in your system.
 */
class ReprocessCaloAction: public CollectionAction {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param externalFlag This can be used to control externally if the event has to be
   *                     reprocessed or not. If NULL, all the events will be reprocessed. If it
   *                     points to a bool variable, an event will be reprocessed only if this variable
   *                     is true.
   */
  ReprocessCaloAction(const char *actionName, bool *externalFlag = NULL) :
    CollectionAction(actionName), _externalFlag(externalFlag), _caloPS(NULL) {

  }

  /*! @brief Destructor. */
  ~ReprocessCaloAction() {
    //delete _caloPS; // This deletes the CaloLevel2 object inside PamLevel2, which generates a
                      // double delete and the consequent segfault when PamLevel2 is deleted... sigh...
  }

  /*! @brief The setup procedure.
   *
   * This will set up the CaloPreSampler member object before the analysis starts.
   *
   * @param events Pointer to the PamLevel2 object which contains the events to analyze.
   */
  void Setup(PamLevel2 *events);

  /* @brief The reprocessing procedure.
   *
   * This will reprocess calorimeter information, depending on the flag set in constructor's parameter list.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief The finalization procedure.
   *
   * Currently it does nothing.
   */
  void Finalize() {

  }

private:

  bool *_externalFlag;
  CaloPreSampler *_caloPS;

};

#endif /* REPROCESSCALOACTION_H_ */

#endif // #ifndef NO_CALOPRESAMPLER
