/*
 * PitchAngleCut.h
 *
 *  Created on: 27-Marth-2010
 *      Author: Vitaly Malakhov
 */

/*! @file PitchAngleCut.h The PitchAngleCut class definition file */

#ifndef PITCHANGLECUT_H_
#define PITCHANGLECUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The pitch-angle cut. */
class PitchAngleCut: public PamCut {
public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name..
   * @param pitchMin The minimum threshold value of the pitch-angle
   * @param pitchMax The maximum threshold value of the pitch-angle
   */
  PitchAngleCut(const char *cutName, Float_t pitchMin, Float_t pitchMax) :
    PamCut(cutName), _pitchMin(pitchMin), _pitchMax(pitchMax) {
  }

  /*! @brief Destructor. */
  ~PitchAngleCut() {
  }

  /*! @brief Apply the geomagnetic cut.
   *
   * This routine rejects the events with pitch-angle > PitchMax and pitch-angle <= PitchMin.
   * @param event The event to analyze.
   * @return CUTOK if PitchMin < pitch-angle <= PitchMax , 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:
  float _pitchMin;
  float _pitchMax;

};

#endif /* PITCHANGLECUT_H_ */
