/*
 * TrkBetaPrVsTofBetaHistoAction.h
 *
 *  Created on: 2009-06-05
 *      Author: S. Ricciarini
 */
/*! @file TrkBetaPrVsTofBetaHistoAction.h The TrkBetaPrVsTofBetaHistoAction class declaration file. */

#ifndef TrkBetaPrVsTofBetaHISTOACTION_H_
#define TrkBetaPrVsTofBetaHISTOACTION_H_

#include "../CollectionAction/CollectionAction.h"
#include <TH2F.h>

/*! @brief An action that fills the histogram: TRK beta modulus (assuming proton) vs TOF beta modulus.
 */
class TrkBetaPrVsTofBetaHistoAction: public CollectionAction {

public:
  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name.
   *
   * @param mode The mode of file creation (see documentation of TFile constructor
   * in ROOT's reference guide)
   */

  TrkBetaPrVsTofBetaHistoAction(const char *actionName, TString outFileName, TString mode = "UPDATE");

  /*! @brief Destructor */
  ~TrkBetaPrVsTofBetaHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the histogram to the output file. */
  void Finalize();

private:

  TString _outFileName;
  TH2F _histo;
  TString _mode;

};

#endif /* TrkBetaPrVsTofBetaHISTOACTION_H_ */
